/*!
 * @file        main.h
 *
 * @brief       Header for main.c module
 *
 * @version     V1.0.2
 *
 * @date        2022-06-23
 *
 * @attention
 *
 *  Copyright (C) 2021-2022 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be usefull and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Define to prevent recursive inclusion */
#ifndef __MAIN_H
#define __MAIN_H

#ifdef __cplusplus
  extern "C" {
#endif

/* Includes */
#include "apm32f4xx.h"
#include "apm32f4xx_eth.h"
#include "board_DP83848.h"

#include "lwip/tcp.h"
#include "lwip/mem.h"
#include "lwip/memp.h"
#include "lwip/tcp.h"
#include "lwip/tcp_impl.h"
#include "lwip/udp.h"
#include "netif/etharp.h"
#include "lwip/dhcp.h"
#include "ethernetif.h"

#include <stdio.h>

/** @addtogroup Examples
  @{
  */

/** @addtogroup ETH_Ping
  @{
  */

#if defined (APM32F407_MINI)
#define BOARD_COM1     MINI_COM1
#elif defined (APM32F407_ELE_HUETB)
#define BOARD_COM1     ELE_COM1
#else
#error "Please select first the APM32  board to be used (in board.h)"
#endif

/** @defgroup ETH_Ping_Functions Functions
  @{
  */

void LwIP_Init(void);
void LwIP_Pkt_Handle(void);
void LwIP_Periodic_Handle(__IO uint32_t ETHTimer);

extern volatile uint32_t ETHTimer;

#ifdef __cplusplus
}
#endif

#endif /* __MAIN_H */

/**@} end of group ETH_Ping_Functions */
/**@} end of group ETH_Ping */
/**@} end of group Examples */
